<?php

namespace App\Enums;

enum UserStatusEnum: int
{
    case PENDING = 0;
    case ACTIVE = 1;
    case BLOCKED = 2;
    case NEED_APPROVAL = 3;

    public static function getNameFromValue(int $value): string
    {
        return match ($value) {
            self::PENDING->value => self::PENDING->name,
            self::ACTIVE->value => self::ACTIVE->name,
            self::BLOCKED->value => self::BLOCKED->name,
            self::NEED_APPROVAL->value => self::NEED_APPROVAL->name,
        };
    }
}
