<?php

namespace App\Enums;

enum StatusEnum: int
{
    case INACTIVE = 0;
    case ACTIVE = 1;

    public static function getNameFromValue(int $value): string
    {
        return match ($value) {
            self::ACTIVE->value => self::ACTIVE->name,
            self::INACTIVE->value => self::INACTIVE->name,
        };
    }
}
