<?php

namespace App\Enums\Project;

enum OfferType: int
{
    case SALE = 1;      
    case RENT = 2;        
    case INVESTMENT = 3; 

    public function label(): string
    {
        return match($this) {
            self::SALE => 'sale',
            self::RENT => 'rent',
            self::INVESTMENT => 'investment',
        };
    }

    public static function labels(): array
    {
        return collect(self::cases())->mapWithKeys(fn ($case) => [
            $case->value => $case->label()
        ])->toArray();
    }
}
