<?php

namespace App\Dto\V1;

use Illuminate\Http\UploadedFile;

class TagDto
{
    public function __construct(
        public ?string       $nameEn = null,
        public ?string       $nameAr = null,
        public ?bool         $status = null,
        public ?UploadedFile $icon = null,
    )
    {
    }

    public function createPayload(): array
    {
        return [
            'name_en' => $this->nameEn,
            'name_ar' => $this->nameAr,
            'status' => $this->status,
            'icon' => $this->icon,
        ];
    }

    public function updatePayload(string $icon): array
    {
        $data = [
            'name_en' => $this->nameEn,
            'name_ar' => $this->nameAr,
            'status' => $this->status,
        ];

        if ($this->icon) {
            delete_s3_image($icon, 'tags/icons');
            $data['icon'] = upload_s3_images($this->icon, 'tags/icons');
        }

        return $data;
    }

    public function changeStatusPayload(): array
    {
        return [
            'status' => $this->status,
        ];
    }
}
