<?php

namespace App\Dto\V1;

use Illuminate\Http\UploadedFile;

class SliderDto
{
    public function __construct(
        public ?string       $page = null,
        public ?bool         $status = null,
        public ?UploadedFile $imageEn = null,
        public ?UploadedFile $imageAr = null,
        public ?string       $titleEn = null,
        public ?string       $titleAr = null,
    )
    {
    }

    public function createPayload(): array
    {
        return [
            'page' => $this->page,
            'status' => $this->status,
            'image_en' => $this->imageEn,
            'image_ar' => $this->imageAr,
            'title_en' => $this->titleEn,
            'title_ar' => $this->titleAr,
        ];
    }

    public function updatePayload(?string $imageEnPath = null, ?string $imageArPath = null): array
    {
        $data = [
            'page' => $this->page,
            'status' => $this->status,
            'title_en' => $this->titleEn,
            'title_ar' => $this->titleAr,
        ];

        if ($this->imageEn) {
            if ($imageEnPath) {
                delete_s3_image($imageEnPath, 'sliders');
            }
            $data['image_en'] = upload_s3_images($this->imageEn, 'sliders');
        }

        if ($this->imageAr) {
            if ($imageArPath) {
                delete_s3_image($imageArPath, 'sliders');
            }
            $data['image_ar'] = upload_s3_images($this->imageAr, 'sliders');
        }

        return $data;
    }

    public function changeStatusPayload(): array
    {
        return [
            'status' => $this->status,
        ];
    }
}
