<?php

namespace App\Dto\V1;

class SettingDto
{
    public function __construct(
        public string $name,
        public mixed  $value = null,
    )
    {
    }


    public function updatePayload(): array
    {
        $value = $this->value;
        if (is_file($this->value)) {
            $value = upload_s3_images($this->value, 'settings');
        }
        return [
            'value' => $value,
        ];
    }
}
