<?php

namespace App\Dto\V1\Project;

class ProjectCommentDto
{
    public function __construct(
        public string $comment,
        public ?int   $parentId = null
    )
    {
    }

    public function storePayload(int $projectId, int $userId): array
    {
        return [
            'project_id' => $projectId,
            'comment' => $this->comment,
            'user_id' => $userId,
            'parent_id' => $this->parentId,
        ];
    }
}
