<?php

namespace App\Dto\V1;

class CityDto
{
    public function __construct(
        public ?string $nameEn = null,
        public ?string $nameAr = null,
        public ?bool   $status = null,
        public ?int    $stateId = null,
    )
    {
    }

    public function createPayload(): array
    {
        return [
            'name_en' => $this->nameEn,
            'name_ar' => $this->nameAr,
            'status' => $this->status,
            'state_id' => $this->stateId,
        ];
    }

    public function updatePayload(): array
    {
        return [
            'name_en' => $this->nameEn,
            'name_ar' => $this->nameAr,
            'status' => $this->status,
            'state_id' => $this->stateId,
        ];
    }

    public function changeStatusPayload(): array
    {
        return [
            'status' => $this->status,
        ];
    }
}
