<?php

namespace App\Dto\V1;

class BlogDto
{
    public function __construct(
        public ?string $nameEn = null,
        public ?string $nameAr = null,
        public ?string $titleEn = null,
        public ?string $titleAr = null,
        public ?string $descriptionEn = null,
        public ?string $descriptionAr = null,
        public ?array $images = [],
        public ?string $metaTitleEn = null,
        public ?string $metaTitleAr = null,
        public ?string $metaDescriptionEn = null,
        public ?string $metaDescriptionAr = null,
        public array $deletedImages = [],
        public ?string $altImageEn = null,
        public ?string $altImageAr = null,
    ) {
    }

    public function blogStorePayload(): array
    {
        return [
            'name_en' => $this->nameEn,
            'name_ar' => $this->nameAr,
            'title_en' => $this->titleEn,
            'title_ar' => $this->titleAr,
            'description_en' => $this->descriptionEn,
            'description_ar' => $this->descriptionAr,
            'meta_title_en' => $this->metaTitleEn,
            'meta_title_ar' => $this->metaTitleAr,
            'meta_description_en' => $this->metaDescriptionEn,'meta_description_ar' => $this->metaDescriptionAr,
            'alt_image_en' => $this->altImageEn,
            'alt_image_ar' => $this->altImageAr,
        ];
    }

    public function blogUpdatePayload(): array
    {
        return array_filter([
            'name_en' => $this->nameEn,
            'name_ar' => $this->nameAr,
            'title_en' => $this->titleEn,
            'title_ar' => $this->titleAr,
            'description_en' => $this->descriptionEn,
            'description_ar' => $this->descriptionAr,
            'meta_title_en' => $this->metaTitleEn,
            'meta_title_ar' => $this->metaTitleAr,
            'meta_description_en' => $this->metaDescriptionEn,'meta_description_ar' => $this->metaDescriptionAr,
            'alt_image_en' => $this->altImageEn,
            'alt_image_ar' => $this->altImageAr,
        ], static function ($value) {
            return $value !== null;
        });
    }
}
