<?php

namespace App\Dto\V1\Blog;

use Illuminate\Http\UploadedFile;

class BlogImageDto
{
    /**
     * @param UploadedFile[] $images
     */
    public function __construct(
        public array $images,
    ) {}

    public function uploadImagePayload(): array
    {
        $paths = [];

        foreach ($this->images as $image) {
            if (! $image instanceof UploadedFile) {
                continue;
            }

            $paths[] = $image->store('blogs', 'public');
        }

        return [
            'images' => $paths,
        ];
    }
}

