<?php

namespace App\Actions\V1\Users;

use App\Repositories\V1\Users\UserRepositoryInterface;
use Illuminate\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;

readonly class UserListAction
{
    public function __construct(private UserRepositoryInterface $repository)
    {
    }

    public function execute(Utility $utility, int $limit): LengthAwarePaginator
    {
        return $this->repository->index($utility, $limit);
    }
}
