<?php

namespace App\Actions\V1\Tags;

use App\Dto\V1\TagDto;
use App\Models\Tag;
use App\Repositories\V1\Tags\TagRepositoryInterface;

readonly class StoreTagAction
{
    public function __construct(private TagRepositoryInterface $tagRepository)
    {
    }

    public function execute(TagDto $dto): Tag
    {
        return $this->tagRepository->create($dto->createPayload());
    }
}
