<?php

namespace App\Actions\V1\Tags;

use App\Models\Tag;
use App\Repositories\V1\Tags\TagRepositoryInterface;

readonly class GetTagAction
{
    public function __construct(private TagRepositoryInterface $tagRepository)
    {
    }

    public function execute(int $id): Tag
    {
        return $this->tagRepository->getById($id);
    }
}
