<?php

namespace App\Actions\V1\SubCategories;

use App\Models\SubCategory;
use App\Dto\V1\SubCategoryDto;
use App\Repositories\V1\SubCategories\SubCategoryRepositoryInterface;

readonly class UpdateSubCategoryAction
{
    public function __construct(
        private SubCategoryRepositoryInterface $repository
    ) {}

    public function execute(SubCategoryDto $dto, int $id): SubCategory
    {
        return $this->repository->update($dto, $id);
    }
}
