<?php

namespace App\Actions\V1\SubCategories;

use App\Models\SubCategory;
use App\Dto\V1\SubCategoryDto;
use App\Repositories\V1\SubCategories\SubCategoryRepositoryInterface;

readonly class StoreSubCategoryAction
{
    public function __construct(
        private SubCategoryRepositoryInterface $repository
    ) {}

    public function execute(SubCategoryDto $dto): SubCategory
    {
        return $this->repository->store($dto);
    }
}
