<?php

namespace App\Actions\V1\States;

use App\Dto\V1\StateDto;
use App\Models\State;
use App\Repositories\V1\States\StateRepositoryInterface;

readonly class StoreStateAction
{
    public function __construct(private StateRepositoryInterface $repository)
    {
    }

    public function execute(StateDto $dto): State
    {
        return $this->repository->create($dto->createPayload());
    }
}
