<?php

namespace App\Actions\V1\States;

use App\Repositories\V1\States\StateRepositoryInterface;
use Illuminate\Database\Eloquent\Collection;
use Infrastructure\Services\Utilities\Utility;
use Infrastructure\Services\Utilities\States\StatesUtility;
use Illuminate\Pagination\LengthAwarePaginator;

class StateListAction
{
    public function __construct(private StateRepositoryInterface $repository) {}

    public function execute(StatesUtility $utility): Collection
    {
        return $this->repository->index($utility);
    }

    public function executeWithPagination(StatesUtility $utility, int $limit): LengthAwarePaginator
    {
        return $this->repository->indexPaginated($utility, $limit);
    }
}
