<?php

namespace App\Actions\V1\Sliders;

use App\Repositories\V1\Sliders\SliderRepositoryInterface;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;

readonly class SliderListAction
{
    public function __construct(private SliderRepositoryInterface $sliderRepository)
    {
    }
    public function execute(Utility $utility, int $limit): LengthAwarePaginator
    {
        return $this->sliderRepository->index($utility, $limit);
    }
}
