<?php

namespace App\Actions\V1\Settings;

use App\Dto\V1\SettingDto;
use App\Repositories\V1\Settings\SettingRepositoryInterface;

readonly class UpdateSettingAction
{
    public function __construct(private SettingRepositoryInterface $repository) {}

    public function execute(SettingDto $dto): void
    {
        $this->repository->updateOrCreate(
            ['name' => $dto->name],
            $dto->updatePayload()
        );
    }
}
