<?php

namespace App\Actions\V1\Settings;

use App\Models\Setting;
use App\Repositories\V1\Settings\SettingRepositoryInterface;

readonly class GetSettingAction
{
    public function __construct(private SettingRepositoryInterface $repository)
    {
    }

    public function execute(int $id): Setting
    {
        return $this->repository->getById($id);
    }
}
