<?php

namespace App\Actions\V1\Service;

use App\Models\Service;
use Illuminate\Database\Eloquent\ModelNotFoundException;

class GetServiceAction
{
    /**
     * Execute the action to get a single service by ID
     *
     * @param int $id
     * @return Service
     * @throws ModelNotFoundException
     */
    public function execute(int $id): Service
    {
        return Service::findOrFail($id);
    }
}
