<?php

namespace App\Actions\V1\Roles;

use App\Dto\V1\RoleDto;
use App\Repositories\V1\Roles\PermissionRepositoryInterface;
use Spatie\Permission\Models\Role;

readonly class UpdateRoleAction
{
    public function __construct(private PermissionRepositoryInterface $permissionRepository)
    {
    }

    public function execute(RoleDto $dto, int $id): Role
    {
        $this->permissionRepository->update($id, $dto->rolePayload());
        $permissions = $this->permissionRepository->getPermissionsByIds($dto->permissionIds);

        $role = $this->permissionRepository->getById($id);
        $role->syncPermissions($permissions);
        return $role;
    }
}
