<?php

namespace App\Actions\V1\Project;

use App\Repositories\V1\Projects\ProjectRepositoryInterface;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;

readonly class IndexProjectAction
{
    public function __construct(private ProjectRepositoryInterface $projectRepository)
    {
    }

    public function execute(Utility $utility): LengthAwarePaginator
    {
        return $this->projectRepository->getProjects($utility);
    }
}
