<?php

namespace App\Actions\V1\Project;

use App\Repositories\V1\Projects\ProjectCommentRepositoryInterface;
use Illuminate\Pagination\LengthAwarePaginator;

readonly class GetProjectCommentsAction
{
    public function __construct(private ProjectCommentRepositoryInterface $projectCommentRepository)
    {
    }

    public function execute(int $projectId, int $limit): LengthAwarePaginator
    {
        return $this->projectCommentRepository->getTopLevelComments($projectId, $limit);
    }
}
