<?php

namespace App\Actions\V1\Project;

use App\Repositories\V1\Projects\ProjectRepositoryInterface;
use Illuminate\Database\Eloquent\Collection;
use Infrastructure\Services\Utilities\Utility;

readonly class GetProfessionalProjectsAction
{
    public function __construct(private ProjectRepositoryInterface $projectRepository)
    {
    }

    public function execute(Utility $utility, int $userId): Collection
    {
        return $this->projectRepository->getProfessionalProjects($utility, $userId);
    }
}
