<?php

namespace App\Actions\V1\Project;

use App\Models\Project;
use App\Repositories\V1\Projects\ProjectRepositoryInterface;
use Illuminate\Database\Eloquent\ModelNotFoundException;

readonly class GetProfessionalProjectDetailsAction
{
    public function __construct(private ProjectRepositoryInterface $projectRepository)
    {
    }

    public function execute(int $id, int $userId): Project
    {

        $project = $this->projectRepository->getProjectWithDetails($id);
        if (!$project || $project->user_id != $userId) {
            throw new ModelNotFoundException(__('exceptions.project_not_found'));
        }

        return $project;
    }
}
