<?php

namespace App\Actions\V1\Labels;

use App\Dto\V1\LabelDto;
use App\Models\Label;
use App\Repositories\V1\Labels\LabelRepositoryInterface;

readonly class StoreLabelAction
{
    public function __construct(private LabelRepositoryInterface $repository)
    {
    }

    public function execute(LabelDto $dto): Label
    {
        return $this->repository->create($dto->createPayload());
    }
}
