<?php

namespace App\Actions\V1\Labels;

use App\Repositories\V1\Labels\LabelRepositoryInterface;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;

readonly class LabelListAction
{
    public function __construct(private LabelRepositoryInterface $repository)
    {
    }
    public function execute(Utility $utility, int $limit): LengthAwarePaginator
    {
        return $this->repository->index($utility, $limit);
    }
}
