<?php

namespace App\Actions\V1\InternalUsers;

use App\Models\InternalUser;
use App\Repositories\V1\InternalUsers\InternalUserRepositoryInterface;

readonly class GetInternalUserAction
{
    public function __construct(private InternalUserRepositoryInterface $internalUserRepository)
    {
    }

    public function execute(int $id): InternalUser
    {
        return $this->internalUserRepository->getById($id);
    }
}
