<?php

namespace App\Actions\V1\InternalUsers;

use App\Dto\V1\InternalUserDto;
use App\Repositories\V1\InternalUsers\InternalUserRepositoryInterface;

readonly class ChangeInternalUserStatusAction
{
    public function __construct(private InternalUserRepositoryInterface $internalUserRepository)
    {
    }

    public function execute(InternalUserDto $dto, int $id): bool
    {
        return $this->internalUserRepository->update($id, $dto->changeStatusPayload());
    }
}
