<?php

namespace App\Actions\V1\FooterTitles;

use App\Dto\V1\FooterTitleDto;
use App\Repositories\V1\Footers\FooterTitleRepositoryInterface;

readonly class UpdateFooterTitleAction
{
    public function __construct(private FooterTitleRepositoryInterface $repository)
    {
    }

    public function execute(FooterTitleDto $dto, int $id): bool
    {
        return $this->repository->update($id, $dto->updatePayload());
    }
}
