<?php

namespace App\Actions\V1\FooterTitles;

use App\Dto\V1\FooterTitleDto;
use App\Models\FooterTitle;
use App\Repositories\V1\Footers\FooterTitleRepositoryInterface;

readonly class StoreFooterTitleAction
{
    public function __construct(private FooterTitleRepositoryInterface $repository)
    {
    }

    public function execute(FooterTitleDto $dto): FooterTitle
    {
        return $this->repository->create($dto->createPayload());
    }
}
