<?php

namespace App\Actions\V1\FooterTitleDetails;

use App\Dto\V1\FooterTitleDetailDto;
use App\Models\FooterTitleDetail;
use App\Repositories\V1\Footers\FooterTitleDetailRepositoryInterface;

readonly class StoreFooterTitleDetailAction
{
    public function __construct(private FooterTitleDetailRepositoryInterface $repository)
    {
    }

    public function execute(FooterTitleDetailDto $dto): FooterTitleDetail
    {
        return $this->repository->create($dto->createPayload());
    }
}
