<?php

namespace App\Actions\V1\FooterTitleDetails;

use App\Repositories\V1\Footers\FooterTitleDetailRepositoryInterface;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;

readonly class FooterTitleDetailListAction
{
    public function __construct(private FooterTitleDetailRepositoryInterface $repository)
    {
    }
    public function execute(Utility $utility, int $limit): LengthAwarePaginator
    {
        return $this->repository->index($utility, $limit);
    }
        public function executeAll(Utility $utility)
    {
        return $this->repository->indexAll($utility);
    }
}
