<?php

namespace App\Actions\V1\Currencies;

use App\Repositories\V1\Currencies\CurrencyRepositoryInterface;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;

readonly class CurrencyListAction
{
    public function __construct(private CurrencyRepositoryInterface $repository)
    {
    }
    public function execute(Utility $utility, int $limit): LengthAwarePaginator
    {
        return $this->repository->index($utility, $limit);
    }
}
