<?php

namespace App\Actions\V1\Countries;

use App\Repositories\V1\Countries\CountryRepositoryInterface;
use Illuminate\Database\Eloquent\Collection;
use Infrastructure\Services\Utilities\Countries\CountriesUtility;
use Illuminate\Pagination\LengthAwarePaginator;

class CountryListAction
{
    public function __construct(private CountryRepositoryInterface $repository) {}

    public function execute(CountriesUtility $utility): Collection
    {
        return $this->repository->index($utility);
    }

    public function executeWithPagination(CountriesUtility $utility, int $limit): LengthAwarePaginator
    {
        return $this->repository->indexPaginated($utility, $limit);
    }
}
