<?php

namespace App\Actions\V1\Countries;

use App\Dto\V1\CountryDto;
use App\Repositories\V1\Countries\CountryRepositoryInterface;

readonly class ChangeCountryStatusAction
{
    public function __construct(private CountryRepositoryInterface $repository) {}

    public function execute(CountryDto $dto, int $id): bool
    {
        return $this->repository->update($id, $dto->changeStatusPayload());
    }
}