<?php

namespace App\Actions\V1\Contacts;

use App\Repositories\V1\Contacts\ContactRepositoryInterface;
use Illuminate\Pagination\LengthAwarePaginator;

readonly class ContactListAction
{
    public function __construct(private ContactRepositoryInterface $repository)
    {
    }

    public function execute(int $limit): LengthAwarePaginator
    {
        return $this->repository->index($limit);
    }
}

