<?php

namespace App\Actions\V1\Cities;

use App\Dto\V1\CityDto;
use App\Models\City;
use App\Repositories\V1\Cities\CityRepositoryInterface;

readonly class StoreCityAction
{
    public function __construct(private CityRepositoryInterface $repository)
    {
    }

    public function execute(CityDto $dto): City
    {
        return $this->repository->create($dto->createPayload());
    }
}
