<?php

namespace App\Actions\V1\Cities;

use App\Dto\V1\CityDto;
use App\Repositories\V1\Cities\CityRepositoryInterface;

readonly class ChangeCityStatusAction
{
    public function __construct(private CityRepositoryInterface $repository)
    {
    }

    public function execute(CityDto $dto, int $id): bool
    {
        return $this->repository->update($id, $dto->changeStatusPayload());
    }
}
