<?php

namespace App\Actions\V1\Categories;

use App\Dto\V1\CategoryDto;
use App\Repositories\V1\Categories\CategoryRepositoryInterface;

readonly class UpdateCategoryAction
{
    public function __construct(private CategoryRepositoryInterface $categoryRepository)
    {
    }

    public function execute(CategoryDto $dto, int $id): bool
    {
        $category = $this->categoryRepository->getById($id);
        return $this->categoryRepository->update($id, $dto->updatePayload($category->getRawOriginal('image'), $category->getRawOriginal('icon')));
    }
}
