<?php

namespace App\Actions\V1\Categories;

use App\Dto\V1\CategoryDto;
use App\Models\Category;
use App\Repositories\V1\Categories\CategoryRepositoryInterface;

readonly class StoreCategoryAction
{
    public function __construct(private CategoryRepositoryInterface $categoryRepository)
    {
    }

    public function execute(CategoryDto $dto): Category
    {
        return $this->categoryRepository->create($dto->createPayload());
    }
}
