<?php

namespace App\Actions\V1\Categories;

use App\Models\Category;
use App\Repositories\V1\Categories\CategoryRepositoryInterface;

readonly class GetCategoryAction
{
    public function __construct(private CategoryRepositoryInterface $categoryRepository)
    {
    }

    public function execute(int $id): Category
    {
        return $this->categoryRepository->getById($id);
    }
}
