<?php

namespace App\Actions\V1\Blog;

use App\Dto\V1\Blog\BlogImagesDto;
use App\Models\BlogImage;

readonly class UploadImagesAction
{
    public function execute(BlogImagesDto $dto): array
    {
        $images = [];
        foreach ($dto->uploadImagesPayload() as $imageData) {
            $images[] = BlogImage::query()->create($imageData);
        }
        return $images;
    }
}

