<?php

namespace App\Actions\V1\Blog;

use App\Dto\V1\Blog\BlogImageDto;
use App\Repositories\V1\Blogs\BlogImageRepositoryInterface;
use Illuminate\Support\Collection;

readonly class UploadImageAction
{
    public function __construct(private BlogImageRepositoryInterface $blogImageRepository)

    {
    }

    public function execute(BlogImageDto $dto): Collection
    {
        return $this->blogImageRepository->create($dto->uploadImagePayload());
    }
}

