<?php

namespace App\Actions\V1\Blog;

use App\Dto\V1\BlogDto;
use App\Models\Blog;
use App\Repositories\V1\Blogs\BlogImageRepositoryInterface;
use App\Repositories\V1\Blogs\BlogRepositoryInterface;

readonly class StoreBlogAction
{
    public function __construct(
        private BlogRepositoryInterface $blogRepository,
        private BlogImageRepositoryInterface $blogImageRepository
    )
    {
    }

   
    public function execute(BlogDto $dto): Blog
{
    $blog = $this->blogRepository->create(
        $dto->blogStorePayload()
    );

    $images = $this->blogImageRepository->create(
        blogId: $blog->id,
        images: $dto->images
    );


    return $blog;
}

}

