<?php

namespace App\Actions\V1\Blog;

use App\Models\Blog;
use App\Repositories\V1\Blogs\BlogRepositoryInterface;

readonly class GetBlogAction
{
    public function __construct(private BlogRepositoryInterface $repository)
    {
    }

    public function execute(int $id): Blog
    {
        return $this->repository->getById($id);
    }
}

