<?php

namespace App\Actions\V1\Auth;

use App\Dto\V1\Auth\AuthDto;
use App\Enums\StatusEnum;
use App\Enums\UserStatusEnum;
use App\Exceptions\Auth\BlockedUserException;
use App\Exceptions\Auth\invalidCredentialsException;
use App\Exceptions\Auth\UserNotExistsException;
use App\Http\Resources\V1\InternalUserResource;
use App\Repositories\V1\InternalUsers\InternalUserRepositoryInterface;
use Illuminate\Support\Facades\Hash;

readonly class  LoginAction
{
    public function __construct(private InternalUserRepositoryInterface $internalUserRepository)
    {
    }

    /**
     * @param AuthDto $dto
     * @return array
     * @throws UserNotExistsException
     * @throws invalidCredentialsException
     * @throws BlockedUserException
     */
    public function execute(AuthDto $dto): array
    {
        $user = $this->internalUserRepository->first(['phone_number' => $dto->phoneNumber]);
        if (!$user) {
            throw new UserNotExistsException();
        }

        if (!Hash::check($dto->password, $user->password)) {
            throw new invalidCredentialsException();
        }

        if ($user->status == StatusEnum::INACTIVE->value) {
            throw new BlockedUserException();
        }

        return [
            'user' => InternalUserResource::make($user),
            'token' => $user->createToken('admin_token')->plainTextToken,
        ];
    }
}
