<?php

namespace App\Actions\V1\Auth;

use App\Dto\V1\Auth\UserDto;
use App\Exceptions\LogicalException;
use App\Repositories\V1\InternalUsers\InternalUserRepositoryInterface;
use Illuminate\Support\Facades\Hash;

readonly class ChangeCurrentPasswordAction
{
    public function __construct(private InternalUserRepositoryInterface $internalUserRepository)
    {
    }

    /**
     * @param UserDto $dto
     * @param int $userId
     * @return void
     * @throws LogicalException
     */
    public function execute(UserDto $dto, int $userId): void
    {
        $user = $this->internalUserRepository->first(['id' => $userId]);

        if (!Hash::check($dto->oldPassword, $user->password)) {
            throw new LogicalException(__('exceptions.wrong_password'));
        }

        $this->internalUserRepository->update($user->id, ['password' => Hash::make($dto->password)]);
    }
}
