<?php

namespace Infrastructure\Services\Utilities\Sliders\Filters;

use Illuminate\Database\Eloquent\Builder;
use Infrastructure\Services\Utilities\UtilityInterface;

class PageFilter implements UtilityInterface
{
    public static function query(Builder $builder, mixed $value): void
    {
        $builder->where('page', '=', $value);
    }

    public static function key(): string
    {
        return 'page_type';
    }
}
